
// We can get command line arguments in a node program
// Here we're checking to make sure we've typed three things (the last being the filename)
if (process.argv.length < 3) {
  console.log('Oops, you forgot to pass in a text file.');
  process.exit(1);
}

// The 'fs' (file system) module allows us to read and write files
// http://nodejs.org/api/fs.html
var fs = require('fs');
var filename = process.argv[2];

// Read the file as utf8 and process the data in the flesch function
fs.readFile(filename, 'utf8', flesch);

function flesch(err, data) {
  if (err) {
    throw err;
  }

    var totalSyllables = 0;
    var totalSentences = 0;
    var totalWords     = 0;

    var delimiters = /[.:;?! !@#$%^&*()]+/;
    //split words up into an array called words
    var words = data.split(delimiters);

    //iterate through words
    for (var i = 0; i < words.length; i++) {
      //put each word into a spot in the array
      var word = words[i];
     //here we are using function written below
      totalSyllables += countSyllables(word);
      totalWords++;
    }

    // Look for sentence delimiters
    var sentenceDelim = /[.:;?!]/;
    var sentences = data.split(sentenceDelim);
    totalSentences = sentences.length;

    // Calculate flesch index
    var f1 = 206.835;
    var f2 = 84.6;
    var f3 = 1.015;
    var r1 = totalSyllables / totalWords;
    var r2 = totalWords / totalSentences;
    var flesch = f1 - (f2 * r1) - (f3 * r2);

    // Write Report
    var report = "";

    report += "Total Syllables: " + totalSyllables + "\n";
    report += "Total Words    : " + totalWords + "\n";
    report += "Total Sentences: " + totalSentences + "\n";
    report += "Flesch Index   : " + flesch + "\n";
    console.log(report);
  }


// A method to count the number of syllables in a word
// Pretty basic, just based off of the number of vowels
// This could be improved. We pass it a word
function countSyllables(word) {
  //set up some variables
  var syl    = 0;
  var vowel  = false;
  var length = word.length;

  //iterate over the letters in each word
  // Check each word for vowels (don't count more than one vowel in a row)
  for (var i = 0; i < length; i++) {
    //pass each letter to isVowel to see if it returns true.
    //double condition to check that there are not two vowels in a row
    if (isVowel(word.charAt(i)) && (vowel == false)) {
      vowel = true;
      syl++; //increase counter for syllables
    } else if (isVowel(word.charAt(i)) && (vowel == true)) { //double vowel so ignore.
      vowel = true;
    } else {
      vowel = false; //not a vowel
    }
  }

//get the character at word.length-1 (ie the last character)
  var tempChar = word.charAt(word.length-1);
  // Check for 'e' at the end, as long as not a word w/ one syllable
  if (((tempChar == 'e') || (tempChar == 'E')) && (syl != 1)) {
    syl--; //if true, dont count this
  }
  return syl; //if false do count this
}

// return function to check for vowels
// give it a character
// Check if a char is a vowel (count y) with these if statements
function isVowel(c) {
  if      ((c == 'a') || (c == 'A')) { return true;  }
  else if ((c == 'e') || (c == 'E')) { return true;  }
  else if ((c == 'i') || (c == 'I')) { return true;  }
  else if ((c == 'o') || (c == 'O')) { return true;  }
  else if ((c == 'u') || (c == 'U')) { return true;  }
  else if ((c == 'y') || (c == 'Y')) { return true;  }
  else                               { return false; }
}
