
// We can get command line arguments in a node program
// Here we're checking to make sure we've typed three things (the last being the filename)
// this time we want 4 arguments
if (process.argv.length < 4) {
  console.log('Oops, you forgot to pass in a text file or a word to search for.');
  process.exit(1);
}

// The 'fs' (file system) module allows us to read and write files
// http://nodejs.org/api/fs.html
var fs = require('fs');
var filename = process.argv[2];

//set search word to be the 4th argument
var searchTerm = process.argv[3];

// Read the file as utf8 and process the data in the searching function
fs.readFile(filename, 'utf8', search);

//here is the everyother function
function search(err, data) {
  if (err) {
    throw err;
  }

  var count =0;

  // Split text by wherever there is a space
  var words = data.split(' ');

  //iterate over each word in the words array
  for (var i = 0; i < words.length-1; i++) {
    //if we come across a match

    if (words[i] == searchTerm) {

      count++;
      console.log(words[i] + ' '  + words[i+1]);
      console.log(count);
    }
  }
}
